

<?php $__env->startSection('title', 'Our Medical Team'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Hero Section -->
    <section class="bg-gradient-to-br from-primary-50 to-blue-50 py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center fade-in-up">
                <h1 class="heading-large text-primary-600 mb-6">Meet Our Medical Team</h1>
                <p class="body-large text-gray-600 max-w-3xl mx-auto">
                    Our experienced and compassionate healthcare professionals are dedicated to providing 
                    exceptional medical care to patients across Ogun State and beyond.
                </p>
            </div>
        </div>
    </section>

    <!-- Leadership Team -->
    <section class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16 fade-in-up">
                <h2 class="heading-large text-gray-900 mb-4">Leadership Team</h2>
                <p class="body-large text-gray-600 max-w-2xl mx-auto">
                    Meet the experienced leaders guiding our mission to deliver world-class healthcare
                </p>
            </div>

            <!-- Chief Medical Director -->
            <div class="mb-20">
                <div class="grid lg:grid-cols-2 gap-12 items-center fade-in-up">
                    <div class="order-2 lg:order-1">
                        <div class="bg-blue-50 p-2 rounded-xl">
                            <div class="w-full h-96 bg-gradient-to-br from-blue-200 to-blue-300 rounded-lg flex items-center justify-center">
                                <div class="text-center">
                                    <div class="w-24 h-24 bg-blue-600 rounded-full flex items-center justify-center mx-auto mb-4">
                                        <span class="text-white text-2xl font-bold">AJ</span>
                                    </div>
                                    <p class="text-blue-600 font-medium">Professional Photo</p>
                                    <p class="text-blue-500 text-sm">Dr. Adebayo Johnson</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="order-1 lg:order-2">
                        <div class="bg-blue-50 p-8 rounded-xl">
                            <h3 class="text-2xl font-bold text-gray-900 mb-2">Dr. Adebayo Johnson</h3>
                            <p class="text-blue-600 font-semibold text-lg mb-4">Chief Medical Director</p>
                            
                            <div class="space-y-4 text-gray-600">
                                <p>
                                    Dr. Johnson brings over 15 years of medical excellence to Winicare Services. 
                                    A graduate of the University of Ibadan College of Medicine, he specializes in 
                                    internal medicine and healthcare administration.
                                </p>
                                <p>
                                    His vision of accessible, high-quality healthcare for all Nigerians drives our 
                                    commitment to community service and medical innovation.
                                </p>
                            </div>

                            <div class="mt-6 grid grid-cols-2 gap-4">
                                <div class="bg-white p-4 rounded-lg">
                                    <div class="text-blue-600 font-bold text-lg">15+</div>
                                    <div class="text-gray-600 text-sm">Years Experience</div>
                                </div>
                                <div class="bg-white p-4 rounded-lg">
                                    <div class="text-blue-600 font-bold text-lg">MB;BS</div>
                                    <div class="text-gray-600 text-sm">University of Ibadan</div>
                                </div>
                            </div>

                            <div class="mt-6">
                                <h4 class="font-semibold text-gray-900 mb-2">Specializations:</h4>
                                <div class="flex flex-wrap gap-2">
                                    <span class="px-3 py-1 bg-blue-100 text-blue-700 rounded-full text-sm">Internal Medicine</span>
                                    <span class="px-3 py-1 bg-blue-100 text-blue-700 rounded-full text-sm">Healthcare Administration</span>
                                    <span class="px-3 py-1 bg-blue-100 text-blue-700 rounded-full text-sm">Community Health</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Other Leadership -->
            <div class="grid md:grid-cols-2 gap-12">
                <!-- Head of Pediatrics -->
                <div class="fade-in-up">
                    <div class="bg-white border border-gray-200 rounded-xl p-8 hover:shadow-lg transition-shadow duration-300">
                        <div class="flex items-start space-x-6">
                            <div class="w-20 h-20 bg-gradient-to-br from-green-400 to-green-600 rounded-full flex items-center justify-center flex-shrink-0">
                                <span class="text-white font-bold text-xl">PA</span>
                            </div>
                            <div class="flex-1">
                                <h3 class="text-xl font-bold text-gray-900 mb-1">Dr. Patricia Adeyemi</h3>
                                <p class="text-green-600 font-semibold mb-3">Head of Pediatrics</p>
                                <p class="text-gray-600 text-sm mb-4">
                                    Specializing in children's healthcare with over 12 years of experience. 
                                    Dr. Adeyemi leads our pediatric department and community outreach programs.
                                </p>
                                <div class="space-y-2">
                                    <div class="flex items-center text-sm text-gray-600">
                                        <span class="font-medium mr-2">Education:</span> University of Lagos
                                    </div>
                                    <div class="flex items-center text-sm text-gray-600">
                                        <span class="font-medium mr-2">Experience:</span> 12+ years
                                    </div>
                                </div>
                                <div class="mt-4 flex flex-wrap gap-1">
                                    <span class="px-2 py-1 bg-green-100 text-green-700 rounded text-xs">Pediatrics</span>
                                    <span class="px-2 py-1 bg-green-100 text-green-700 rounded text-xs">Neonatology</span>
                                    <span class="px-2 py-1 bg-green-100 text-green-700 rounded text-xs">Child Development</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Chief Pharmacist -->
                <div class="fade-in-up">
                    <div class="bg-white border border-gray-200 rounded-xl p-8 hover:shadow-lg transition-shadow duration-300">
                        <div class="flex items-start space-x-6">
                            <div class="w-20 h-20 bg-gradient-to-br from-purple-400 to-purple-600 rounded-full flex items-center justify-center flex-shrink-0">
                                <span class="text-white font-bold text-xl">AB</span>
                            </div>
                            <div class="flex-1">
                                <h3 class="text-xl font-bold text-gray-900 mb-1">Pharmacist Ahmed Bello</h3>
                                <p class="text-purple-600 font-semibold mb-3">Chief Pharmacist</p>
                                <p class="text-gray-600 text-sm mb-4">
                                    Ensuring safe and effective medication management for all patients. 
                                    Ahmed oversees our pharmacy operations and medication safety protocols.
                                </p>
                                <div class="space-y-2">
                                    <div class="flex items-center text-sm text-gray-600">
                                        <span class="font-medium mr-2">Education:</span> Obafemi Awolowo University
                                    </div>
                                    <div class="flex items-center text-sm text-gray-600">
                                        <span class="font-medium mr-2">Experience:</span> 10+ years
                                    </div>
                                </div>
                                <div class="mt-4 flex flex-wrap gap-1">
                                    <span class="px-2 py-1 bg-purple-100 text-purple-700 rounded text-xs">Clinical Pharmacy</span>
                                    <span class="px-2 py-1 bg-purple-100 text-purple-700 rounded text-xs">Drug Safety</span>
                                    <span class="px-2 py-1 bg-purple-100 text-purple-700 rounded text-xs">Medication Management</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Medical Staff -->
    <section class="py-20 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16 fade-in-up">
                <h2 class="heading-large text-gray-900 mb-4">Our Medical Professionals</h2>
                <p class="body-large text-gray-600 max-w-2xl mx-auto">
                    A dedicated team of specialists committed to your health and wellbeing
                </p>
            </div>

            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
                <!-- Emergency Medicine Specialist -->
                <div class="bg-white rounded-xl p-6 shadow-sm hover:shadow-md transition-shadow duration-300 fade-in-up">
                    <div class="text-center">
                        <div class="w-16 h-16 bg-gradient-to-br from-red-400 to-red-600 rounded-full flex items-center justify-center mx-auto mb-4">
                            <span class="text-white font-bold text-lg">DO</span>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-1">Dr. Olumide Onikoyi</h3>
                        <p class="text-red-600 font-medium text-sm mb-3">Emergency Medicine Specialist</p>
                        <p class="text-gray-600 text-xs mb-4">
                            Leads our 24/7 emergency department with expertise in critical care and trauma management.
                        </p>
                        <div class="flex flex-wrap justify-center gap-1">
                            <span class="px-2 py-1 bg-red-100 text-red-700 rounded text-xs">Emergency Care</span>
                            <span class="px-2 py-1 bg-red-100 text-red-700 rounded text-xs">Trauma</span>
                        </div>
                    </div>
                </div>

                <!-- Gynecologist -->
                <div class="bg-white rounded-xl p-6 shadow-sm hover:shadow-md transition-shadow duration-300 fade-in-up">
                    <div class="text-center">
                        <div class="w-16 h-16 bg-gradient-to-br from-pink-400 to-pink-600 rounded-full flex items-center justify-center mx-auto mb-4">
                            <span class="text-white font-bold text-lg">FA</span>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-1">Dr. Folake Adebayo</h3>
                        <p class="text-pink-600 font-medium text-sm mb-3">Gynecologist & Obstetrician</p>
                        <p class="text-gray-600 text-xs mb-4">
                            Providing comprehensive women's healthcare services including maternity and reproductive health.
                        </p>
                        <div class="flex flex-wrap justify-center gap-1">
                            <span class="px-2 py-1 bg-pink-100 text-pink-700 rounded text-xs">Obstetrics</span>
                            <span class="px-2 py-1 bg-pink-100 text-pink-700 rounded text-xs">Women's Health</span>
                        </div>
                    </div>
                </div>

                <!-- General Surgeon -->
                <div class="bg-white rounded-xl p-6 shadow-sm hover:shadow-md transition-shadow duration-300 fade-in-up">
                    <div class="text-center">
                        <div class="w-16 h-16 bg-gradient-to-br from-indigo-400 to-indigo-600 rounded-full flex items-center justify-center mx-auto mb-4">
                            <span class="text-white font-bold text-lg">KO</span>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-1">Dr. Kemi Ogunyemi</h3>
                        <p class="text-indigo-600 font-medium text-sm mb-3">General Surgeon</p>
                        <p class="text-gray-600 text-xs mb-4">
                            Expert in various surgical procedures with a focus on minimally invasive techniques.
                        </p>
                        <div class="flex flex-wrap justify-center gap-1">
                            <span class="px-2 py-1 bg-indigo-100 text-indigo-700 rounded text-xs">General Surgery</span>
                            <span class="px-2 py-1 bg-indigo-100 text-indigo-700 rounded text-xs">Laparoscopy</span>
                        </div>
                    </div>
                </div>

                <!-- Cardiologist -->
                <div class="bg-white rounded-xl p-6 shadow-sm hover:shadow-md transition-shadow duration-300 fade-in-up">
                    <div class="text-center">
                        <div class="w-16 h-16 bg-gradient-to-br from-orange-400 to-orange-600 rounded-full flex items-center justify-center mx-auto mb-4">
                            <span class="text-white font-bold text-lg">BO</span>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-1">Dr. Bayo Oladele</h3>
                        <p class="text-orange-600 font-medium text-sm mb-3">Cardiologist</p>
                        <p class="text-gray-600 text-xs mb-4">
                            Specialized in heart health, cardiovascular disease prevention and treatment.
                        </p>
                        <div class="flex flex-wrap justify-center gap-1">
                            <span class="px-2 py-1 bg-orange-100 text-orange-700 rounded text-xs">Cardiology</span>
                            <span class="px-2 py-1 bg-orange-100 text-orange-700 rounded text-xs">Heart Disease</span>
                        </div>
                    </div>
                </div>

                <!-- Orthopedic Surgeon -->
                <div class="bg-white rounded-xl p-6 shadow-sm hover:shadow-md transition-shadow duration-300 fade-in-up">
                    <div class="text-center">
                        <div class="w-16 h-16 bg-gradient-to-br from-teal-400 to-teal-600 rounded-full flex items-center justify-center mx-auto mb-4">
                            <span class="text-white font-bold text-lg">AA</span>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-1">Dr. Adunni Afolabi</h3>
                        <p class="text-teal-600 font-medium text-sm mb-3">Orthopedic Surgeon</p>
                        <p class="text-gray-600 text-xs mb-4">
                            Expert in bone, joint, and muscle disorders with focus on sports medicine.
                        </p>
                        <div class="flex flex-wrap justify-center gap-1">
                            <span class="px-2 py-1 bg-teal-100 text-teal-700 rounded text-xs">Orthopedics</span>
                            <span class="px-2 py-1 bg-teal-100 text-teal-700 rounded text-xs">Sports Medicine</span>
                        </div>
                    </div>
                </div>

                <!-- Dermatologist -->
                <div class="bg-white rounded-xl p-6 shadow-sm hover:shadow-md transition-shadow duration-300 fade-in-up">
                    <div class="text-center">
                        <div class="w-16 h-16 bg-gradient-to-br from-cyan-400 to-cyan-600 rounded-full flex items-center justify-center mx-auto mb-4">
                            <span class="text-white font-bold text-lg">TO</span>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-1">Dr. Tope Ogundipe</h3>
                        <p class="text-cyan-600 font-medium text-sm mb-3">Dermatologist</p>
                        <p class="text-gray-600 text-xs mb-4">
                            Specializing in skin health, dermatological conditions, and cosmetic treatments.
                        </p>
                        <div class="flex flex-wrap justify-center gap-1">
                            <span class="px-2 py-1 bg-cyan-100 text-cyan-700 rounded text-xs">Dermatology</span>
                            <span class="px-2 py-1 bg-cyan-100 text-cyan-700 rounded text-xs">Skin Care</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Support Staff -->
    <section class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16 fade-in-up">
                <h2 class="heading-large text-gray-900 mb-4">Our Support Team</h2>
                <p class="body-large text-gray-600 max-w-2xl mx-auto">
                    Behind every great medical team is an exceptional support staff dedicated to your care
                </p>
            </div>

            <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
                <div class="text-center fade-in-up">
                    <div class="w-16 h-16 bg-gradient-to-br from-green-400 to-green-500 rounded-full flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Nursing Staff</h3>
                    <p class="text-gray-600 text-sm">20+ experienced nurses providing round-the-clock patient care</p>
                </div>

                <div class="text-center fade-in-up">
                    <div class="w-16 h-16 bg-gradient-to-br from-blue-400 to-blue-500 rounded-full flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.387-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Lab Technicians</h3>
                    <p class="text-gray-600 text-sm">Skilled technicians ensuring accurate diagnostic results</p>
                </div>

                <div class="text-center fade-in-up">
                    <div class="w-16 h-16 bg-gradient-to-br from-purple-400 to-purple-500 rounded-full flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Patient Services</h3>
                    <p class="text-gray-600 text-sm">Dedicated staff helping with appointments and inquiries</p>
                </div>

                <div class="text-center fade-in-up">
                    <div class="w-16 h-16 bg-gradient-to-br from-orange-400 to-orange-500 rounded-full flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Administrative Team</h3>
                    <p class="text-gray-600 text-sm">Efficient administration ensuring smooth operations</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Join Our Team -->
    <section class="py-20 bg-primary-600">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h2 class="display-medium text-white mb-6">Join Our Team</h2>
            <p class="text-xl text-blue-100 mb-8">
                We're always looking for passionate healthcare professionals to join our mission 
                of providing exceptional medical care to our community.
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="/contact" class="bg-white text-primary-600 btn-primary hover:bg-blue-50">
                    View Career Opportunities
                </a>
                <a href="mailto:careers@winicare.ng" class="btn-secondary bg-transparent border-white text-white hover:bg-white hover:text-primary-600">
                    Send Your Resume
                </a>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\Winicare\winicare\resources\views/team.blade.php ENDPATH**/ ?>