<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="description" content="Winicare Services provides exceptional healthcare solutions in Ogun State, Nigeria. We offer comprehensive medical services with modern facilities and experienced professionals.">

    <title><?php echo e($title ?? 'Winicare Services'); ?> - Healthcare Excellence in Nigeria</title>

    <!-- Fonts Preconnect -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

    <!-- Modern Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&family=Plus+Jakarta+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@400;500;600;700&display=swap" rel="stylesheet" />

    <!-- Critical CSS Framework -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- Custom Enhancements -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    <style>
        /* Critical override styles */
        html, body {
            margin: 0 !important;
            padding: 0 !important;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif !important;
            line-height: 1.6 !important;
            color: #111827 !important;
            background-color: #f9fafb !important;
            -webkit-font-smoothing: antialiased !important;
            -moz-osx-font-smoothing: grayscale !important;
        }

        /* Typography Scale */
        .display-xl { font-size: clamp(3.5rem, 8vw, 5rem); font-weight: 700; line-height: 1.1; letter-spacing: -0.02em; }
        .display-lg { font-size: clamp(3rem, 7vw, 4.5rem); font-weight: 600; line-height: 1.2; letter-spacing: -0.01em; }
        .display-md { font-size: clamp(2.5rem, 6vw, 4rem); font-weight: 600; line-height: 1.3; letter-spacing: -0.01em; }
        .heading-xl { font-size: clamp(2.25rem, 5vw, 3.25rem); font-weight: 700; line-height: 1.3; letter-spacing: -0.01em; }
        .heading-lg { font-size: clamp(2rem, 4vw, 3rem); font-weight: 700; line-height: 1.4; letter-spacing: -0.01em; }
        .heading-md { font-size: clamp(1.5rem, 3vw, 2.25rem); font-weight: 600; line-height: 1.4; letter-spacing: 0; }
        .body-lg { font-size: 1.25rem; font-weight: 400; line-height: 1.7; letter-spacing: 0; }
        .body-md { font-size: 1.125rem; font-weight: 400; line-height: 1.6; letter-spacing: 0; }

        /* Core Color System */
        :root {
            --primary-50: #eff6ff;
            --primary-100: #dbeafe;
            --primary-200: #bfdbfe;
            --primary-300: #93c5fd;
            --primary-400: #60a5fa;
            --primary-500: #3b82f6;
            --primary-600: #006494;
            --primary-700: #005a8a;
            --primary-800: #004970;
            --primary-900: #003851;
        }

        /* Navigation Styles */
        .nav-blur {
            backdrop-filter: blur(20px) saturate(180%);
            background: rgba(255, 255, 255, 0.95);
            border-bottom: 1px solid rgba(0, 0, 0, 0.1);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 50;
            transition: all 0.3s ease;
        }

        /* Button System */
        .btn-primary {
            background: linear-gradient(135deg, #006494 0%, #0891b2 100%);
            color: white;
            font-weight: 600;
            padding: 0.875rem 2rem;
            border-radius: 0.5rem;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .btn-primary:hover {
            transform: translateY(-1px);
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }

        .btn-secondary {
            background: white;
            color: #006494;
            font-weight: 600;
            padding: 0.875rem 2rem;
            border-radius: 0.5rem;
            border: 2px solid #006494;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .btn-secondary:hover {
            background: #006494;
            color: white;
            transform: translateY(-1px);
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }

        /* Hero Section */
        .hero-gradient {
            background: linear-gradient(135deg, #006494 0%, #0891b2 50%, #06b6d4 100%);
            position: relative;
            overflow: hidden;
        }
        .hero-pattern {
            background-image:
                radial-gradient(circle at 25% 25%, rgba(255, 255, 255, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 75% 75%, rgba(255, 255, 255, 0.1) 0%, transparent 50%);
        }

        /* Bento Grid System */
        .bento-grid {
            display: grid;
            gap: 1.5rem;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            grid-auto-rows: 180px;
            margin-top: 2rem;
        }

        .bento-item {
            background: white;
            border-radius: 1rem;
            padding: 2rem;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
            border: 1px solid rgba(0, 0, 0, 0.1);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            overflow: hidden;
            position: relative;
        }
        .bento-item:hover {
            transform: translateY(-8px);
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        }

        .bento-item-large { grid-column: span 2; grid-row: span 2; }
        .bento-item-tall { grid-row: span 2; }
        .bento-item-wide { grid-column: span 2; }

        /* Animations */
        @keyframes fadeInUp {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        @keyframes slideInLeft {
            from { opacity: 0; transform: translateX(-30px); }
            to { opacity: 1; transform: translateX(0); }
        }

        .fade-in-up { animation: fadeInUp 0.6s ease-out forwards; }
        .slide-in-left { animation: slideInLeft 0.6s ease-out forwards; }

        /* Mobile Optimizations */
        @media (max-width: 768px) {
            .bento-grid {
                grid-template-columns: 1fr;
                grid-auto-rows: auto;
            }
            .bento-item { padding: 1.5rem; }
            .bento-item-large,
            .bento-item-tall,
            .bento-item-wide { grid-column: span 1; grid-row: span 1; }
            .display-xl { font-size: clamp(2.5rem, 12vw, 4rem); }
            .display-lg { font-size: clamp(2rem, 10vw, 3.5rem); }
            .heading-xl { font-size: clamp(1.875rem, 8vw, 2.75rem); }
        }
    </style>
</head>
<body class="antialiased">
    <!-- Navigation -->
    <nav class="nav-blur shadow-sm">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center py-4">
                <!-- Logo -->
                <a href="/" class="flex items-center space-x-2 text-2xl font-bold text-gray-900 transition-colors duration-300 hover:text-gray-700">
                    <div class="w-8 h-8 bg-gradient-to-br from-blue-600 to-blue-800 rounded-md flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>
                        </svg>
                    </div>
                    <span class="tracking-tight">
                        W<i class="text-blue-600">INICARE</i>
                    </span>
                </a>

                <!-- Desktop Menu -->
                <div class="hidden md:flex items-center space-x-8">
                    <a href="/" class="text-gray-700 hover:text-blue-600 font-medium transition-colors duration-300">Home</a>
                    <a href="/about" class="text-gray-700 hover:text-blue-600 font-medium transition-colors duration-300">About</a>
                    <a href="/services" class="text-gray-700 hover:text-blue-600 font-medium transition-colors duration-300">Services</a>
                    <a href="/contact" class="btn-primary">
                        Get Started
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                        </svg>
                    </a>
                </div>

                <!-- Mobile Menu Button -->
                <div class="md:hidden">
                    <button class="mobile-menu-btn text-gray-700 hover:text-blue-600 p-2 rounded-md hover:bg-gray-100 transition-colors duration-300">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                        </svg>
                    </button>
                </div>
            </div>

            <!-- Mobile Menu -->
            <div class="mobile-menu hidden md:hidden bg-white border-t border-gray-200 mt-2 rounded-b-lg shadow-lg">
                <div class="px-4 py-4 space-y-3">
                    <a href="/" class="block text-gray-700 hover:text-blue-600 font-medium transition-colors duration-300 py-2 rounded-md hover:bg-gray-50">Home</a>
                    <a href="/about" class="block text-gray-700 hover:text-blue-600 font-medium transition-colors duration-300 py-2 rounded-md hover:bg-gray-50">About</a>
                    <a href="/services" class="block text-gray-700 hover:text-blue-600 font-medium transition-colors duration-300 py-2 rounded-md hover:bg-gray-50">Services</a>
                    <a href="/contact" class="block text-gray-700 hover:text-blue-600 font-medium transition-colors duration-300 py-2 rounded-md hover:bg-gray-50">Contact</a>
                    <a href="/contact" class="btn-primary mt-3 w-full justify-center">Get Started</a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="pt-16">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Footer -->
    <footer class="bg-gray-900 text-white py-16 mt-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid md:grid-cols-4 gap-8">
                <!-- Brand Section -->
                <div class="md:col-span-2">
                    <div class="mb-8">
                        <div class="flex items-center space-x-2 mb-4">
                            <div class="w-10 h-10 bg-white rounded-lg flex items-center justify-center">
                                <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>
                                </svg>
                            </div>
                            <div class="text-2xl font-bold">
                                W<i class="text-blue-400">INICARE</i>
                            </div>
                        </div>
                        <p class="text-gray-300 mb-6 max-w-md">
                            Delivering exceptional healthcare services in Ogun State, Nigeria. We are committed to providing quality medical care with compassion and expertise.
                        </p>
                    </div>
                    <div class="flex space-x-4">
                        <a href="#" class="text-gray-400 hover:text-white transition-colors duration-300 p-2 rounded-full hover:bg-gray-800" aria-label="Facebook">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M24 4.557c-.883.392-1.832.656-2.828.775 1.017-.609 1.798-1.574 2.165-2.724-.951.564-2.005.974-3.127 1.195-.897-.957-2.178-1.555-3.594-1.555-3.179 0-5.515 2.966-4.797 6.045-4.091-.205-7.719-2.165-10.148-5.144-1.29 2.213-.669 5.108 1.523 6.574-.806-.026-1.566-.247-2.229-.616-.054 2.281 1.581 4.415 3.949 4.89-.693.188-1.452.232-2.224.084.626 1.956 2.444 3.379 4.6 3.419-2.07 1.623-4.678 2.348-7.29 2.04 2.179 1.397 4.768 2.212 7.548 2.212 9.142 0 14.307-7.721 13.995-14.646.962-.695 1.797-1.562 2.457-2.549z"/>
                            </svg>
                        </a>
                        <a href="#" class="text-gray-400 hover:text-white transition-colors duration-300 p-2 rounded-full hover:bg-gray-800" aria-label="Twitter">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M22.46 6c-.77.35-1.6.58-2.46.69.88-.53 1.56-1.37 1.88-2.38-.83.5-1.75.85-2.72 1.05C18.37 4.5 17.26 4 16 4c-2.35 0-4.27 1.92-4.27 4.29 0 .34.04.67.11.98C8.28 9.09 5.11 7.38 3 4.79c-.37.63-.58 1.37-.58 2.15 0 1.49.75 2.81 1.91 3.56-.71 0-1.37-.2-1.95-.5v.03c0 2.08 1.48 3.82 3.44 4.21a4.22 4.22 0 0 1-1.93.07 4.28 4.28 0 0 0 4 2.98 8.521 8.521 0 0 1-5.33 1.84c-.34 0-.68-.02-1.02-.06C3.44 20.29 5.7 21 8.12 21 16 21 20.33 14.46 20.33 8.79c0-.19 0-.37-.01-.56.84-.6 1.56-1.36 2.14-2.23z"/>
                            </svg>
                        </a>
                    </div>
                </div>

                <!-- Services Links -->
                <div>
                    <h3 class="text-lg font-semibold mb-4">Services</h3>
                    <ul class="space-y-2">
                        <li><a href="/services#diagnostic" class="text-gray-300 hover:text-white transition-colors duration-300">Medical Diagnostics</a></li>
                        <li><a href="/services#emergency" class="text-gray-300 hover:text-white transition-colors duration-300">Emergency Care</a></li>
                        <li><a href="/services#outreach" class="text-gray-300 hover:text-white transition-colors duration-300">Community Outreach</a></li>
                        <li><a href="/services#consumer" class="text-gray-300 hover:text-white transition-colors duration-300">Patient Education</a></li>
                    </ul>
                </div>

                <!-- Contact Info -->
                <div>
                    <h3 class="text-lg font-semibold mb-4">Contact Info</h3>
                    <ul class="space-y-2 text-gray-300">
                        <li>Ogun State, Nigeria</li>
                        <li>
                            <a href="tel:+2341234567890" class="hover:text-white transition-colors duration-300">
                                +234 123 456 7890
                            </a>
                        </li>
                        <li>
                            <a href="mailto:info@winicare.ng" class="hover:text-white transition-colors duration-300">
                                info@winicare.ng
                            </a>
                        </li>
                        <li class="pt-2">
                            <a href="/contact" class="inline-flex items-center text-blue-400 hover:text-blue-300 transition-colors duration-300">
                                Get Directions
                                <svg class="w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                </svg>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <div class="border-t border-gray-700 mt-12 pt-8 text-center text-gray-400">
                <p>&copy; <?php echo e(date('Y')); ?> Winicare Services. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/app.js']); ?>
    <script>
        // Mobile Menu Toggle
        document.addEventListener('DOMContentLoaded', function() {
            const mobileMenuBtn = document.querySelector('.mobile-menu-btn');
            const mobileMenu = document.querySelector('.mobile-menu');

            if (mobileMenuBtn && mobileMenu) {
                mobileMenuBtn.addEventListener('click', function() {
                    mobileMenu.classList.toggle('hidden');
                    this.classList.toggle('bg-gray-100');
                });

                // Close menu when clicking outside
                document.addEventListener('click', function(e) {
                    if (!mobileMenuBtn.contains(e.target) && !mobileMenu.contains(e.target)) {
                        mobileMenu.classList.add('hidden');
                        mobileMenuBtn.classList.remove('bg-gray-100');
                    }
                });
            }

            // Add smooth scrolling for anchor links
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function (e) {
                    e.preventDefault();
                    const target = document.querySelector(this.getAttribute('href'));
                    if (target) {
                        target.scrollIntoView({
                            behavior: 'smooth',
                            block: 'start'
                        });
                    }
                });
            });
        });

        // Intersection Observer for animations
        document.addEventListener('DOMContentLoaded', function() {
            const observerOptions = {
                threshold: 0.1,
                rootMargin: '0px 0px -50px 0px'
            };

            const observer = new IntersectionObserver(function(entries) {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('animate');
                    }
                });
            }, observerOptions);

            // Observe elements with animation classes
            document.querySelectorAll('.fade-in-up').forEach(el => observer.observe(el));
        });
    </script>
</body>
</html><?php /**PATH C:\laragon\www\Winicare\winicare\resources\views/layouts/app.blade.php ENDPATH**/ ?>