

<?php $__env->startSection('title', 'Frequently Asked Questions'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Hero Section -->
    <section class="bg-gradient-to-br from-primary-50 to-blue-50 py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center fade-in-up">
                <h1 class="heading-large text-primary-600 mb-6">Frequently Asked Questions</h1>
                <p class="body-large text-gray-600 max-w-3xl mx-auto">
                    Find answers to common questions about our services, appointments, insurance, and healthcare policies.
                    Can't find what you're looking for? Contact us directly.
                </p>
            </div>
        </div>
    </section>

    <!-- FAQ Categories -->
    <section class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid lg:grid-cols-3 gap-8">
                <!-- General Questions -->
                <div class="lg:col-span-2">
                    <div class="space-y-8">
                        <!-- General Information -->
                        <div class="fade-in-up">
                            <h2 class="heading-medium text-gray-900 mb-6">General Information</h2>
                            <div class="space-y-4">
                                <div class="bg-gray-50 rounded-xl p-6">
                                    <h3 class="text-lg font-semibold text-gray-900 mb-3">What services does Winicare Services offer?</h3>
                                    <p class="text-gray-600">
                                        We offer comprehensive healthcare services including general practice, emergency care, 
                                        pediatrics, maternity services, diagnostic imaging, laboratory services, surgical procedures, 
                                        and pharmacy services. We also provide community outreach programs and health education.
                                    </p>
                                </div>

                                <div class="bg-gray-50 rounded-xl p-6">
                                    <h3 class="text-lg font-semibold text-gray-900 mb-3">What are your operating hours?</h3>
                                    <p class="text-gray-600 mb-2">
                                        <strong>Regular Hours:</strong><br>
                                        Monday - Friday: 8:00 AM - 8:00 PM<br>
                                        Saturday: 8:00 AM - 6:00 PM<br>
                                        Sunday: Emergency services only
                                    </p>
                                    <p class="text-gray-600">
                                        <strong>Emergency Services:</strong> Available 24/7 every day of the year.
                                    </p>
                                </div>

                                <div class="bg-gray-50 rounded-xl p-6">
                                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Where is Winicare Services located?</h3>
                                    <p class="text-gray-600">
                                        We are located in Abeokuta, Ogun State, Nigeria. Our facility is easily accessible 
                                        from major roads and public transportation routes throughout Ogun State and neighboring areas.
                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- Appointments -->
                        <div class="fade-in-up">
                            <h2 class="heading-medium text-gray-900 mb-6">Appointments & Scheduling</h2>
                            <div class="space-y-4">
                                <div class="bg-gray-50 rounded-xl p-6">
                                    <h3 class="text-lg font-semibold text-gray-900 mb-3">How do I schedule an appointment?</h3>
                                    <p class="text-gray-600">
                                        You can schedule an appointment by calling us at +234 123 456 7890, visiting our facility, 
                                        or using our online contact form. We recommend calling ahead to ensure your preferred 
                                        time slot is available.
                                    </p>
                                </div>

                                <div class="bg-gray-50 rounded-xl p-6">
                                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Do I need to make an appointment for emergency care?</h3>
                                    <p class="text-gray-600">
                                        No, emergency care is available 24/7 without an appointment. For life-threatening 
                                        emergencies, call our emergency hotline at +234 911 123 4567 or come directly to our facility.
                                    </p>
                                </div>

                                <div class="bg-gray-50 rounded-xl p-6">
                                    <h3 class="text-lg font-semibold text-gray-900 mb-3">What should I bring to my appointment?</h3>
                                    <p class="text-gray-600">
                                        Please bring a valid form of identification, your insurance card (if applicable), 
                                        any previous medical records, current medications list, and method of payment. 
                                        For follow-up visits, bring any test results or referral letters.
                                    </p>
                                </div>

                                <div class="bg-gray-50 rounded-xl p-6">
                                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Can I reschedule or cancel my appointment?</h3>
                                    <p class="text-gray-600">
                                        Yes, you can reschedule or cancel appointments by calling us at least 24 hours in advance. 
                                        This helps us offer your time slot to other patients who may need care.
                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- Insurance & Payment -->
                        <div class="fade-in-up">
                            <h2 class="heading-medium text-gray-900 mb-6">Insurance & Payment</h2>
                            <div class="space-y-4">
                                <div class="bg-gray-50 rounded-xl p-6">
                                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Do you accept health insurance?</h3>
                                    <p class="text-gray-600">
                                        Yes, we work with most major Nigerian health insurance providers including NHIS, 
                                        private insurance companies, and corporate health plans. Please contact us to verify 
                                        if your specific insurance plan is accepted.
                                    </p>
                                </div>

                                <div class="bg-gray-50 rounded-xl p-6">
                                    <h3 class="text-lg font-semibold text-gray-900 mb-3">What payment methods do you accept?</h3>
                                    <p class="text-gray-600">
                                        We accept cash, bank transfers, debit cards, credit cards, mobile money payments, 
                                        and insurance coverage. Payment plans may be available for major procedures - 
                                        please discuss this with our billing department.
                                    </p>
                                </div>

                                <div class="bg-gray-50 rounded-xl p-6">
                                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Do you offer payment plans?</h3>
                                    <p class="text-gray-600">
                                        Yes, we understand that medical expenses can be challenging. We offer flexible payment 
                                        plans for eligible patients. Please speak with our patient financial services team 
                                        to discuss available options.
                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- Medical Care -->
                        <div class="fade-in-up">
                            <h2 class="heading-medium text-gray-900 mb-6">Medical Care & Services</h2>
                            <div class="space-y-4">
                                <div class="bg-gray-50 rounded-xl p-6">
                                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Do you provide maternity services?</h3>
                                    <p class="text-gray-600">
                                        Yes, we offer comprehensive maternity services including prenatal care, delivery services, 
                                        postnatal care, and pediatric care for newborns. Our experienced team provides 
                                        compassionate care throughout your pregnancy journey.
                                    </p>
                                </div>

                                <div class="bg-gray-50 rounded-xl p-6">
                                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Are vaccination services available?</h3>
                                    <p class="text-gray-600">
                                        Yes, we provide routine vaccinations for children and adults, including childhood 
                                        immunizations, travel vaccines, and seasonal flu shots. We also conduct community 
                                        vaccination campaigns in rural areas.
                                    </p>
                                </div>

                                <div class="bg-gray-50 rounded-xl p-6">
                                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Do you have laboratory and diagnostic services?</h3>
                                    <p class="text-gray-600">
                                        Yes, our facility includes a full-service laboratory and diagnostic imaging department. 
                                        We perform blood tests, urine analysis, X-rays, ultrasounds, ECGs, and other diagnostic 
                                        procedures on-site for quick results.
                                    </p>
                                </div>

                                <div class="bg-gray-50 rounded-xl p-6">
                                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Can I get my prescription medications at your facility?</h3>
                                    <p class="text-gray-600">
                                        Yes, we have a fully-stocked pharmacy on-site with licensed pharmacists available 
                                        for medication counseling. We stock both brand-name and generic medications, and 
                                        can order special medications if needed.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Contact & Quick Info -->
                <div class="lg:col-span-1">
                    <div class="sticky top-8 space-y-6">
                        <!-- Contact Information -->
                        <div class="bg-primary-50 rounded-xl p-6 fade-in-up">
                            <h3 class="text-lg font-semibold text-primary-600 mb-4">Still Have Questions?</h3>
                            <p class="text-gray-600 mb-4">
                                Our friendly staff is here to help answer any questions not covered in our FAQ.
                            </p>
                            <div class="space-y-3">
                                <div class="flex items-center text-gray-700">
                                    <svg class="w-5 h-5 text-primary-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
                                    </svg>
                                    <a href="tel:+2341234567890" class="hover:text-primary-600">+234 123 456 7890</a>
                                </div>
                                <div class="flex items-center text-gray-700">
                                    <svg class="w-5 h-5 text-primary-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                                    </svg>
                                    <a href="mailto:info@winicare.ng" class="hover:text-primary-600">info@winicare.ng</a>
                                </div>
                            </div>
                            <a href="/contact" class="btn-primary w-full mt-4 text-center block">
                                Contact Us
                            </a>
                        </div>

                        <!-- Emergency Info -->
                        <div class="bg-red-50 rounded-xl p-6 fade-in-up">
                            <h3 class="text-lg font-semibold text-red-600 mb-4">Emergency Care</h3>
                            <p class="text-gray-600 mb-4">
                                For life-threatening emergencies, call immediately or visit our emergency department.
                            </p>
                            <div class="text-center">
                                <div class="text-2xl font-bold text-red-600 mb-2">+234 911 123 4567</div>
                                <div class="text-sm text-red-600 font-medium">24/7 Emergency Hotline</div>
                            </div>
                        </div>

                        <!-- Popular Services -->
                        <div class="bg-gray-50 rounded-xl p-6 fade-in-up">
                            <h3 class="text-lg font-semibold text-gray-900 mb-4">Popular Services</h3>
                            <ul class="space-y-2">
                                <li><a href="/services#diagnostic" class="text-primary-600 hover:text-primary-700">Medical Diagnostics</a></li>
                                <li><a href="/services#emergency" class="text-primary-600 hover:text-primary-700">Emergency Care</a></li>
                                <li><a href="/services" class="text-primary-600 hover:text-primary-700">Maternal & Child Health</a></li>
                                <li><a href="/services" class="text-primary-600 hover:text-primary-700">General Practice</a></li>
                                <li><a href="/services" class="text-primary-600 hover:text-primary-700">Pharmacy Services</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Additional Help Section -->
    <section class="py-20 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12 fade-in-up">
                <h2 class="heading-large text-gray-900 mb-4">Need Additional Help?</h2>
                <p class="body-large text-gray-600 max-w-2xl mx-auto">
                    We're committed to making your healthcare experience as smooth as possible
                </p>
            </div>

            <div class="grid md:grid-cols-3 gap-8">
                <div class="bg-white rounded-xl p-8 text-center shadow-sm fade-in-up">
                    <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-6">
                        <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-900 mb-4">Chat with Us</h3>
                    <p class="text-gray-600 mb-6">
                        Get real-time answers to your questions during business hours
                    </p>
                    <button class="text-blue-600 font-semibold hover:text-blue-700">Start Chat →</button>
                </div>

                <div class="bg-white rounded-xl p-8 text-center shadow-sm fade-in-up">
                    <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-6">
                        <svg class="w-8 h-8 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-900 mb-4">Download Forms</h3>
                    <p class="text-gray-600 mb-6">
                        Access patient forms and documents to save time during your visit
                    </p>
                    <button class="text-green-600 font-semibold hover:text-green-700">View Forms →</button>
                </div>

                <div class="bg-white rounded-xl p-8 text-center shadow-sm fade-in-up">
                    <div class="w-16 h-16 bg-purple-100 rounded-full flex items-center justify-center mx-auto mb-6">
                        <svg class="w-8 h-8 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-900 mb-4">Visit Us</h3>
                    <p class="text-gray-600 mb-6">
                        Come to our facility for in-person assistance and support
                    </p>
                    <a href="/contact" class="text-purple-600 font-semibold hover:text-purple-700">Get Directions →</a>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\Winicare\winicare\resources\views/faq.blade.php ENDPATH**/ ?>