<?php $__env->startSection('title', 'Contact Us'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Hero Section -->
    <section class="bg-gradient-to-br from-primary-50 to-blue-50 py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center fade-in-up">
                <h1 class="heading-large text-primary-600 mb-6">Get in Touch</h1>
                <p class="body-large text-gray-600 max-w-3xl mx-auto">
                    We're here to serve you. Contact us for appointments, inquiries, or emergency care.
                    Your health and well-being are our top priorities.
                </p>
            </div>
        </div>
    </section>

    <section class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid lg:grid-cols-3 gap-12">
                <!-- Contact Form -->
                <div class="lg:col-span-2 fade-in-up">
                    <div class="bg-white rounded-xl shadow-lg p-8">
                        <h2 class="heading-medium text-gray-900 mb-6">Send us a Message</h2>

                        <form action="#" method="POST" class="space-y-6">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="first_name" class="block text-sm font-medium text-gray-700 mb-2">First Name *</label>
                                    <input type="text" id="first_name" name="first_name" required
                                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-colors duration-200">
                                </div>
                                <div>
                                    <label for="last_name" class="block text-sm font-medium text-gray-700 mb-2">Last Name *</label>
                                    <input type="text" id="last_name" name="last_name" required
                                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-colors duration-200">
                                </div>
                            </div>

                            <div>
                                <label for="email" class="block text-sm font-medium text-gray-700 mb-2">Email Address *</label>
                                <input type="email" id="email" name="email" required
                                       class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-colors duration-200">
                            </div>

                            <div>
                                <label for="phone" class="block text-sm font-medium text-gray-700 mb-2">Phone Number</label>
                                <input type="tel" id="phone" name="phone"
                                       class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-colors duration-200">
                            </div>

                            <div>
                                <label for="service" class="block text-sm font-medium text-gray-700 mb-2">Service Type</label>
                                <select id="service" name="service"
                                        class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-colors duration-200">
                                    <option value="">Select a service</option>
                                    <option value="general">General Consultation</option>
                                    <option value="emergency">Emergency Care</option>
                                    <option value="pediatric">Pediatric Care</option>
                                    <option value="dental">Dental Services</option>
                                    <option value="cardiology">Cardiology</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>

                            <div>
                                <label for="message" class="block text-sm font-medium text-gray-700 mb-2">Message *</label>
                                <textarea id="message" name="message" rows="5" required
                                          placeholder="Tell us about your concerns or questions..."
                                          class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-colors duration-200 resize-vertical"></textarea>
                            </div>

                            <div class="flex items-center">
                                <input type="checkbox" id="consent" name="consent" required
                                       class="h-4 w-4 text-primary-600 focus:ring-primary-500 border-gray-300 rounded">
                                <label for="consent" class="ml-2 block text-sm text-gray-700">
                                    I agree to the processing of my personal data for the purpose of responding to my inquiry. *
                                </label>
                            </div>

                            <button type="submit" class="btn-primary w-full">
                                Send Message
                            </button>
                        </form>
                    </div>
                </div>

                <!-- Contact Information -->
                <div class="fade-in-up">
                    <div class="space-y-8">
                        <!-- Location -->
                        <div class="bg-gray-50 p-6 rounded-xl">
                            <div class="flex items-start space-x-4">
                                <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center flex-shrink-0">
                                    <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Our Location</h3>
                                    <p class="text-gray-600 mb-2">
                                        123 Healthcare Street<br>
                                        Abeokuta, Ogun State<br>
                                        Nigeria
                                    </p>
                                    <a href="#" class="text-blue-600 hover:text-blue-700 font-medium transition-colors duration-300">
                                        Get Directions →
                                    </a>
                                </div>
                            </div>
                        </div>

                        <!-- Contact Numbers -->
                        <div class="bg-gray-50 p-6 rounded-xl">
                            <div class="flex items-start space-x-4">
                                <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center flex-shrink-0">
                                    <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Phone Numbers</h3>
                                    <div class="space-y-2">
                                        <div>
                                            <p class="text-gray-600 font-medium">Main Reception:</p>
                                            <a href="tel:+2341234567890" class="text-green-700 hover:text-green-800 font-medium transition-colors duration-300">
                                                +234 123 456 7890
                                            </a>
                                        </div>
                                        <div>
                                            <p class="text-gray-600 font-medium">Emergency:</p>
                                            <a href="tel:+2349111234567" class="text-red-700 hover:text-red-800 font-medium transition-colors duration-300">
                                                +234 911 123 4567
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Email -->
                        <div class="bg-gray-50 p-6 rounded-xl">
                            <div class="flex items-start space-x-4">
                                <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center flex-shrink-0">
                                    <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Email Us</h3>
                                    <div class="space-y-2">
                                        <div>
                                            <p class="text-gray-600 font-medium">General Inquiries:</p>
                                            <a href="mailto:info@winicare.ng" class="text-purple-700 hover:text-purple-800 font-medium transition-colors duration-300">
                                                info@winicare.ng
                                            </a>
                                        </div>
                                        <div>
                                            <p class="text-gray-600 font-medium">Appointments:</p>
                                            <a href="mailto:appointments@winicare.ng" class="text-purple-700 hover:text-purple-800 font-medium transition-colors duration-300">
                                                appointments@winicare.ng
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Hours -->
                        <div class="bg-gray-50 p-6 rounded-xl">
                            <div class="flex items-start space-x-4">
                                <div class="w-12 h-12 bg-orange-100 rounded-lg flex items-center justify-center flex-shrink-0">
                                    <svg class="w-6 h-6 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Operating Hours</h3>
                                    <div class="space-y-2 text-gray-600">
                                        <div class="flex justify-between">
                                            <span>Monday - Friday:</span>
                                            <span class="font-medium">8:00 AM - 8:00 PM</span>
                                        </div>
                                        <div class="flex justify-between">
                                            <span>Saturday:</span>
                                            <span class="font-medium">8:00 AM - 6:00 PM</span>
                                        </div>
                                        <div class="flex justify-between">
                                            <span>Sunday:</span>
                                            <span class="font-medium">Emergency Only</span>
                                        </div>
                                        <div class="flex justify-between">
                                            <span>Emergency:</span>
                                            <span class="font-medium text-red-600">24/7</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Map Section -->
    <section class="py-20 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12 fade-in-up">
                <h2 class="heading-large text-gray-900 mb-4">Find Us in Ogun State</h2>
                <p class="body-large text-gray-600 max-w-2xl mx-auto">
                    Conveniently located in Abeokuta, easily accessible from major roads and transportation hubs
                    throughout Ogun State, Nigeria.
                </p>
            </div>

            <div class="bg-white rounded-xl shadow-lg overflow-hidden fade-in-up">
                <div class="h-96 bg-gray-200 flex items-center justify-center">
                    <div class="text-center">
                        <svg class="w-16 h-16 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4m0 0L9 7"></path>
                        </svg>
                        <h3 class="text-xl font-semibold text-gray-900 mb-2">Interactive Map</h3>
                        <p class="text-gray-600 mb-4">Location: Abeokuta, Ogun State, Nigeria</p>
                        <p class="text-sm text-gray-500">Interactive map will be embedded here</p>
                    </div>
                </div>
            </div>

            <!-- Transportation Information -->
            <div class="grid md:grid-cols-3 gap-8 mt-12">
                <div class="text-center fade-in-up">
                    <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M8 7v8a1 1 0 001 1h8.586a1 1 0 00.707-1.707l-1.414-1.414A1 1 0 0016 12H9a1 1 0 00-1 1v4a2 2 0 104 0V7a2 2 0 00-4 0z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">By Road</h3>
                    <p class="text-gray-600">Easy access from Lagos-Ibadan Expressway and local roads</p>
                </div>

                <div class="text-center fade-in-up">
                    <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Public Transport</h3>
                    <p class="text-gray-600">Accessible by buses and taxis from major towns in Ogun State</p>
                </div>

                <div class="text-center fade-in-up">
                    <div class="w-16 h-16 bg-purple-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Parking</h3>
                    <p class="text-gray-600">Ample parking space available for patients and visitors</p>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\Winicare\winicare\resources\views/contact.blade.php ENDPATH**/ ?>