@extends('layouts.app')

@section('title', 'Our Services')

@section('content')
    <!-- Hero Section -->
    <section class="bg-gradient-to-br from-primary-50 to-blue-50 py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center fade-in-up">
                <h1 class="heading-large text-primary-600 mb-6">Comprehensive Healthcare Services</h1>
                <p class="body-large text-gray-600 max-w-3xl mx-auto">
                    From preventive care to specialized treatment, we provide a full spectrum of medical services
                    designed to meet the diverse healthcare needs of our community.
                </p>
            </div>
        </div>
    </section>

    <!-- Emergency Services -->
    <section id="emergency" class="py-20 bg-red-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid lg:grid-cols-2 gap-12 items-center">
                <div class="fade-in-up">
                    <div class="flex items-center mb-6">
                        <div class="w-12 h-12 bg-red-100 rounded-lg flex items-center justify-center mr-4">
                            <svg class="w-6 h-6 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L4.082 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                            </svg>
                        </div>
                        <h2 class="heading-medium text-gray-900">24/7 Emergency Care</h2>
                    </div>
                    <p class="text-gray-600 mb-6">
                        Our emergency department is equipped to handle critical situations around the clock.
                        We prioritize rapid response and life-saving interventions, ensuring that help is always available when you need it most.
                    </p>
                    <div class="grid grid-cols-2 gap-4">
                        <div class="flex items-center text-green-700">
                            <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                            </svg>
                            Immediate Response
                        </div>
                        <div class="flex items-center text-green-700">
                            <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                            </svg>
                            Expert Team
                        </div>
                        <div class="flex items-center text-green-700">
                            <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                            </svg>
                            Modern Equipment
                        </div>
                        <div class="flex items-center text-green-700">
                            <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                            </svg>
                            Premium Care
                        </div>
                    </div>
                </div>

                <div class="fade-in-up">
                    <div class="bg-white rounded-xl shadow-lg p-6">
                        <h3 class="text-xl font-semibold text-gray-900 mb-4">Emergency Hotline</h3>
                        <div class="text-center">
                            <div class="text-3xl font-bold text-red-600 mb-2">+234 911 123 4567</div>
                            <p class="text-gray-600 mb-4">Available 24/7 for emergencies</p>
                            <a href="tel:+2349111234567" class="btn-primary bg-red-600 hover:bg-red-700">
                                Call Emergency Line
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Main Services -->
    <section id="diagnostic" class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16 fade-in-up">
                <h2 class="heading-large text-gray-900 mb-4">Our Core Services</h2>
                <p class="body-large text-gray-600 max-w-2xl mx-auto">
                    Comprehensive medical care designed to meet all your healthcare needs
                </p>
            </div>

            <div class="bento-grid">
                <div class="bento-item fade-in-up card-hover">
                    <div class="w-14 h-14 bg-blue-100 rounded-xl flex items-center justify-center mb-4">
                        <svg class="w-7 h-7 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.387-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Medical Diagnostics</h3>
                    <p class="text-gray-600 mb-4">
                        Advanced diagnostic services including laboratory tests, imaging, and specialized screenings
                        for accurate disease detection and treatment planning.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li>• Blood tests & biochemistry</li>
                        <li>• Ultrasound & X-ray services</li>
                        <li>• ECG & cardiovascular diagnostics</li>
                    </ul>
                </div>

                <div class="bento-item fade-in-up card-hover">
                    <div class="w-14 h-14 bg-green-100 rounded-xl flex items-center justify-center mb-4">
                        <svg class="w-7 h-7 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-3">General Practice</h3>
                    <p class="text-gray-600 mb-4">
                        Comprehensive primary healthcare including routine check-ups, vaccinations,
                        chronic disease management, and preventive care.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li>• Regular health screenings</li>
                        <li>• Chronic disease management</li>
                        <li>• Preventive care programs</li>
                    </ul>
                </div>

                <div class="bento-item bento-item-tall fade-in-up card-hover">
                    <div class="w-14 h-14 bg-purple-100 rounded-xl flex items-center justify-center mb-4">
                        <svg class="w-7 h-7 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Maternal & Child Health</h3>
                    <p class="text-gray-600 mb-4">
                        Specialized care for mothers and children including prenatal care, pediatric services,
                        immunization programs, and family planning services.
                    </p>
                    <div class="mt-6 p-4 bg-purple-50 rounded-lg">
                        <p class="font-medium text-purple-800">Free vaccination programs for children under 5</p>
                    </div>
                </div>

                <div class="bento-item fade-in-up card-hover">
                    <div class="w-14 h-14 bg-orange-100 rounded-xl flex items-center justify-center mb-4">
                        <svg class="w-7 h-7 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.387-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Surgical Services</h3>
                    <p class="text-gray-600 mb-4">
                        Safe and effective surgical interventions for various conditions,
                        performed by experienced surgical teams.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li>• General surgery</li>
                        <li>• Minor procedures</li>
                        <li>• Emergency surgery</li>
                    </ul>
                </div>

                <div class="bento-item fade-in-up card-hover">
                    <div class="w-14 h-14 bg-teal-100 rounded-xl flex items-center justify-center mb-4">
                        <svg class="w-7 h-7 text-teal-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Pharmacy Services</h3>
                    <p class="text-gray-600 mb-4">
                        Fully stocked pharmacy with prescription drugs, over-the-counter medications,
                        and professional pharmaceutical counseling.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li>• 24/7 pharmacy access</li>
                        <li>• Medication counseling</li>
                        <li>• Generic alternatives</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <!-- Community Outreach -->
    <section id="outreach" class="py-20 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16 fade-in-up">
                <h2 class="heading-large text-gray-900 mb-4">Community Health Programs</h2>
                <p class="body-large text-gray-600 max-w-2xl mx-auto">
                    We're committed to improving community health through outreach and education programs
                </p>
            </div>

            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
                <div class="bg-white p-8 rounded-xl shadow-sm fade-in-up">
                    <div class="w-16 h-16 bg-green-100 rounded-lg flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-900 mb-4">Health Education Workshops</h3>
                    <p class="text-gray-600 mb-4">
                        Regular workshops on nutrition, hygiene, disease prevention, and healthy living
                        for community members across Ogun State.
                    </p>
                    <div class="text-sm text-green-700 font-medium">15 workshops/month • Free attendance</div>
                </div>

                <div class="bg-white p-8 rounded-xl shadow-sm fade-in-up">
                    <div class="w-16 h-16 bg-blue-100 rounded-lg flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-900 mb-4">Vaccination Campaigns</h3>
                    <p class="text-gray-600 mb-4">
                        Mobile vaccination programs bringing essential vaccines to underserved
                        communities and schools across the state.
                    </p>
                    <div class="text-sm text-blue-700 font-medium">Vaccinations conducted: 12,000+ last year</div>
                </div>

                <div class="bg-white p-8 rounded-xl shadow-sm fade-in-up">
                    <div class="w-16 h-16 bg-purple-100 rounded-lg flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2 2 2 0 012 2v2.945M8 3.935V5.5A2.5 2.5 0 0010.5 8h.5a2 2 0 012 2 2 2 0 104 0 2 2 0 012-2h1.064M15 20.488V18a2 2 0 012-2h3.064"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-900 mb-4">Telemedicine Consultations</h3>
                    <p class="text-gray-600 mb-4">
                        Remote medical consultations for patients in remote areas,
                        connecting them with our specialists through modern technology.
                    </p>
                    <div class="text-sm text-purple-700 font-medium">Available for all specialties</div>
                </div>
            </div>
        </div>
    </section>

    <!-- Call to Action -->
    <section class="py-20 bg-primary-600">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h2 class="display-medium text-white mb-6">Experience Quality Healthcare Today</h2>
            <p class="text-xl text-blue-100 mb-8">
                Don't wait for health concerns to become emergencies. Schedule an appointment
                and take control of your health journey.
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="/contact" class="bg-white text-primary-600 btn-primary hover:bg-blue-50">
                    Book Appointment
                </a>
                <a href="tel:+2341234567890" class="btn-secondary bg-transparent border-white text-white hover:bg-white hover:text-primary-600">
                    Call: +234 123 456 7890
                </a>
            </div>
        </div>
    </section>
@endsection