@extends('layouts.app')

@section('title', 'Home')

@section('content')
    <!-- Hero Section -->
    <section class="relative min-h-screen flex items-center justify-center hero-gradient hero-pattern overflow-hidden">
        <div class="absolute inset-0 bg-black/20"></div>

        <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <div class="fade-in-up mb-8">
                <h1 class="text-white mb-6">
                    <span class="display-large block">Healthcare Excellence</span>
                    <span class="display-medium block text-blue-200">in Ogun State</span>
                </h1>

                <p class="text-xl md:text-2xl text-white/90 max-w-3xl mx-auto mb-8 leading-relaxed fade-in-up">
                    Winicare Services delivers compassionate, high-quality healthcare with modern facilities
                    and experienced professionals. Your health and wellness are our top priority.
                </p>
            </div>

            <div class="fade-in-up flex flex-col sm:flex-row gap-4 justify-center items-center">
                <a href="/services" class="btn-primary bg-white text-primary-600 hover:bg-blue-50">
                    Explore Our Services
                </a>
                <a href="/contact" class="btn-secondary">
                    Get Appointment
                </a>
            </div>
        </div>

        <!-- Floating elements for visual interest -->
        <div class="absolute top-20 right-10 w-20 h-20 bg-white/10 rounded-full animate-pulse"></div>
        <div class="absolute bottom-32 left-10 w-16 h-16 bg-white/10 rounded-full animate-pulse" style="animation-delay: 1s;"></div>
        <div class="absolute top-1/2 left-20 w-12 h-12 bg-white/10 rounded-full animate-pulse" style="animation-delay: 2s;"></div>
    </section>

    <!-- Services Preview Bento Grid -->
    <section class="py-20 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16 fade-in-up">
                <h2 class="heading-large text-gray-900 mb-4">Why Choose Winicare</h2>
                <p class="body-large text-gray-600 max-w-2xl mx-auto">
                    We combine advanced medical technology with personalized care to ensure the best
                    possible outcomes for our patients.
                </p>
            </div>

            <div class="bento-grid">
                <div class="bento-item fade-in-up">
                    <div class="flex items-center space-x-4 mb-4">
                        <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                            <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.031 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                            </svg>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900">Quality Care</h3>
                    </div>
                    <p class="text-gray-600">State-of-the-art medical facilities with experienced healthcare professionals.</p>
                </div>

                <div class="bento-item bento-item-large fade-in-up">
                    <div class="flex items-start space-x-6">
                        <div class="flex-shrink-0">
                            <div class="w-16 h-16 bg-green-100 rounded-lg flex items-center justify-center">
                                <svg class="w-8 h-8 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                                </svg>
                            </div>
                        </div>
                        <div>
                            <h3 class="text-2xl font-semibold text-gray-900 mb-4">24/7 Emergency Care</h3>
                            <p class="text-gray-600 text-lg mb-6">
                                Our emergency department is equipped to handle critical situations around the clock.
                                We prioritize rapid response and life-saving interventions.
                            </p>
                            <a href="/services#emergency" class="text-blue-600 font-semibold hover:text-blue-700 transition-colors duration-300">
                                Learn More →
                            </a>
                        </div>
                    </div>
                </div>

                <div class="bento-item fade-in-up">
                    <div class="flex items-center space-x-4 mb-4">
                        <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center">
                            <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                            </svg>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900">Expert Team</h3>
                    </div>
                    <p class="text-gray-600">Licensed medical professionals with years of experience in various specialties.</p>
                </div>

                <div class="bento-item fade-in-up">
                    <div class="flex items-center space-x-4 mb-4">
                        <div class="w-12 h-12 bg-orange-100 rounded-lg flex items-center justify-center">
                            <svg class="w-6 h-6 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                            </svg>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900">Modern Equipment</h3>
                    </div>
                    <p class="text-gray-600">Advanced medical technology and diagnostic equipment for accurate results.</p>
                </div>

                <div class="bento-item bento-item-tall fade-in-up">
                    <h3 class="text-xl font-semibold text-gray-900 mb-4">Community Health Programs</h3>
                    <p class="text-gray-600 mb-6">
                        We actively engage with the Ogun State community through health education, preventive care programs,
                        and awareness campaigns.
                    </p>
                    <div class="flex items-center space-x-4">
                        <div class="flex-1 bg-blue-50 rounded-lg p-4">
                            <div class="text-2xl font-bold text-blue-600">500+</div>
                            <div class="text-sm text-blue-600">Patients Served Monthly</div>
                        </div>
                        <div class="flex-1 bg-green-50 rounded-lg p-4">
                            <div class="text-2xl font-bold text-green-600">15+</div>
                            <div class="text-sm text-green-600">Healthcare Programs</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Stats Section -->
    <section style="padding: 5rem 0; background-color: white;">
        <div style="max-width: 1280px; margin: 0 auto; padding: 0 1rem;">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 2rem; text-align: center;">
                <div style="animation: fadeInUp 0.6s ease-out forwards;">
                    <div style="font-size: clamp(2.25rem, 5vw, 3rem); font-weight: 700; color: rgb(37 99 235); margin-bottom: 0.5rem;">10+</div>
                    <div style="color: rgb(75 85 99); font-weight: 500; font-size: 1rem;">Years of Service</div>
                </div>
                <div style="animation: fadeInUp 0.6s ease-out forwards;">
                    <div style="font-size: clamp(2.25rem, 5vw, 3rem); font-weight: 700; color: rgb(37 99 235); margin-bottom: 0.5rem;">25+</div>
                    <div style="color: rgb(75 85 99); font-weight: 500; font-size: 1rem;">Medical Specialists</div>
                </div>
                <div style="animation: fadeInUp 0.6s ease-out forwards;">
                    <div style="font-size: clamp(2.25rem, 5vw, 3rem); font-weight: 700; color: rgb(37 99 235); margin-bottom: 0.5rem;">50K+</div>
                    <div style="color: rgb(75 85 99); font-weight: 500; font-size: 1rem;">Patients Treated</div>
                </div>
                <div style="animation: fadeInUp 0.6s ease-out forwards;">
                    <div style="font-size: clamp(2.25rem, 5vw, 3rem); font-weight: 700; color: rgb(37 99 235); margin-bottom: 0.5rem;">98%</div>
                    <div style="color: rgb(75 85 99); font-weight: 500; font-size: 1rem;">Patient Satisfaction</div>
                </div>
            </div>
        </div>
    </section>

    <!-- Call to Action -->
    <section class="py-20 bg-primary-600">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h2 class="display-medium text-white mb-6">Ready to Experience Quality Healthcare?</h2>
            <p class="text-xl text-blue-100 mb-8">
                Schedule an appointment today and take the first step towards better health.
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="/contact" class="bg-white text-primary-600 btn-primary hover:bg-blue-50">
                    Schedule Appointment
                </a>
                <a href="tel:+2341234567890" class="btn-secondary bg-transparent border-white text-white hover:bg-white hover:text-primary-600">
                    Call Now
                </a>
            </div>
        </div>
    </section>
@endsection