@extends('layouts.app')

@section('title', 'About Us')

@section('content')
    <!-- Hero Section -->
    <section class="bg-gradient-to-br from-primary-50 to-blue-50 py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center fade-in-up">
                <h1 class="heading-large text-primary-600 mb-6">About Winicare Services</h1>
                <p class="body-large text-gray-600 max-w-3xl mx-auto">
                    We are a leading healthcare provider in Ogun State, Nigeria, committed to delivering exceptional medical services
                    with compassion, integrity, and excellence.
                </p>
            </div>
        </div>
    </section>

    <!-- Story Section -->
    <section class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid lg:grid-cols-2 gap-16 items-center">
                <div class="fade-in-up">
                    <h2 class="heading-medium text-gray-900 mb-6">Our Story</h2>
                    <div class="space-y-4 text-gray-600">
                        <p>
                            Founded in 2013, Winicare Services emerged from a vision to bridge the gap between quality healthcare
                            access and the growing population of Ogun State. What started as a small clinic has evolved into a
                            comprehensive healthcare institution serving thousands of patients annually.
                        </p>
                        <p>
                            Our journey has been guided by fundamental principles: patient-centered care, continuous innovation,
                            and community service. We've invested heavily in modern medical technology while maintaining the
                            personal touch that defines exceptional healthcare.
                        </p>
                        <p>
                            Today, we stand as a beacon of healthcare excellence in southwestern Nigeria, combining cutting-edge
                            medical practices with cultural sensitivity and genuine compassion for our patients.
                        </p>
                    </div>
                </div>

                <div class="fade-in-up">
                    <div class="grid grid-cols-2 gap-4">
                        <div class="bg-primary-50 p-6 rounded-xl">
                            <div class="text-3xl font-bold text-primary-600 mb-2">10+</div>
                            <div class="text-primary-600">Years of Service</div>
                        </div>
                        <div class="bg-blue-50 p-6 rounded-xl">
                            <div class="text-3xl font-bold text-blue-600 mb-2">25+</div>
                            <div class="text-blue-600">Expert Team</div>
                        </div>
                        <div class="bg-green-50 p-6 rounded-xl">
                            <div class="text-3xl font-bold text-green-600 mb-2">50K+</div>
                            <div class="text-green-600">Lives Touched</div>
                        </div>
                        <div class="bg-purple-50 p-6 rounded-xl">
                            <div class="text-3xl font-bold text-purple-600 mb-2">98%</div>
                            <div class="text-purple-600">Patient Satisfaction</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Mission & Values -->
    <section class="py-20 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16 fade-in-up">
                <h2 class="heading-large text-gray-900 mb-4">Our Mission & Values</h2>
                <p class="body-large text-gray-600 max-w-2xl mx-auto">
                    What drives us every day to provide exceptional healthcare services
                </p>
            </div>

            <div class="grid md:grid-cols-3 gap-8">
                <div class="bg-white p-8 rounded-xl shadow-sm fade-in-up">
                    <div class="w-16 h-16 bg-blue-100 rounded-lg flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-900 mb-4">Patient-Centered Care</h3>
                    <p class="text-gray-600">
                        Every decision we make is focused on what's best for our patients. We listen, we care, we heal.
                    </p>
                </div>

                <div class="bg-white p-8 rounded-xl shadow-sm fade-in-up">
                    <div class="w-16 h-16 bg-green-100 rounded-lg flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-900 mb-4">Quality Excellence</h3>
                    <p class="text-gray-600">
                        We maintain the highest standards in medical care, technology, and service delivery.
                    </p>
                </div>

                <div class="bg-white p-8 rounded-xl shadow-sm fade-in-up">
                    <div class="w-16 h-16 bg-purple-100 rounded-lg flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9v-9m0-9v9"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-900 mb-4">Innovation</h3>
                    <p class="text-gray-600">
                        We embrace new technologies and methodologies to improve patient outcomes and experiences.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Team Section -->
    <section class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16 fade-in-up">
                <h2 class="heading-large text-gray-900 mb-4">Meet Our Leadership Team</h2>
                <p class="body-large text-gray-600 max-w-2xl mx-auto">
                    Dedicated professionals committed to advancing healthcare in our community
                </p>
            </div>

            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
                <div class="text-center fade-in-up">
                    <div class="w-full h-64 bg-gradient-to-br from-blue-100 to-blue-200 rounded-xl mb-6 flex items-center justify-center">
                        <svg class="w-16 h-16 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-900 mb-2">Dr. Adebayo Johnson</h3>
                    <p class="text-primary-600 font-medium mb-2">Chief Medical Director</p>
                    <p class="text-gray-600">Over 15 years of experience in internal medicine and healthcare administration.</p>
                </div>

                <div class="text-center fade-in-up">
                    <div class="w-full h-64 bg-gradient-to-br from-green-100 to-green-200 rounded-xl mb-6 flex items-center justify-center">
                        <svg class="w-16 h-16 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-900 mb-2">Dr. Patricia Adeyemi</h3>
                    <p class="text-primary-600 font-medium mb-2">Head of Pediatrics</p>
                    <p class="text-gray-600">Specialized in children's healthcare with passion for community outreach programs.</p>
                </div>

                <div class="text-center fade-in-up">
                    <div class="w-full h-64 bg-gradient-to-br from-purple-100 to-purple-200 rounded-xl mb-6 flex items-center justify-center">
                        <svg class="w-16 h-16 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-900 mb-2">Pharmacist Ahmed Bello</h3>
                    <p class="text-primary-600 font-medium mb-2">Chief Pharmacist</p>
                    <p class="text-gray-600">Ensuring safe and effective medication management for all our patients.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Location Section -->
    <section class="py-20 bg-primary-600">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h2 class="display-medium text-white mb-6">Serving Ogun State with Pride</h2>
            <p class="text-xl text-blue-100 mb-8">
                From our roots in Ogun State to the broader communities we serve, we're committed to making healthcare
                accessible and affordable for everyone.
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <div class="bg-white/10 backdrop-blur-sm rounded-lg p-6">
                    <h3 class="text-white font-semibold mb-2">📍 Our Location</h3>
                    <p class="text-blue-100">Abeokuta, Ogun State, Nigeria</p>
                </div>
                <div class="bg-white/10 backdrop-blur-sm rounded-lg p-6">
                    <h3 class="text-white font-semibold mb-2">🕒 Hours</h3>
                    <p class="text-blue-100">24/7 Emergency Care Available</p>
                </div>
                <div class="bg-white/10 backdrop-blur-sm rounded-lg p-6">
                    <h3 class="text-white font-semibold mb-2">📞 Contact</h3>
                    <p class="text-blue-100">+234 123 456 7890</p>
                </div>
            </div>
        </div>
    </section>
@endsection